#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <tcl.h>
#include <tk.h>

#include "global.h"
#include "info_aqui.h"
#include "tcl_info_aqui.h"

int num_stat1(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
Tcl_ResetResult(interp);
Tcl_SetObjResult(interp,Tcl_NewIntObj(num_stat()));
return TCL_OK;
}

int stat_name(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: stat_name requires one argument",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: stat_name: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=num_stat()){
	Tcl_AppendResult(interp,"ERROR: stat_name: index too big",NULL);
	return TCL_ERROR;
	}	
Tcl_AppendResult(interp,get_stat(i)->name,NULL);
return TCL_OK;
}


int find_stat(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: find_stat requires one argument",NULL);
	return TCL_ERROR;
	}
for(i=0;i<num_stat();i++)
	if(!strcmp(get_stat(i)->name,argv[1])){
		Tcl_SetObjResult(interp,Tcl_NewIntObj(i));
		return TCL_OK;
		}	
Tcl_SetObjResult(interp,Tcl_NewIntObj(-1));
return TCL_OK;
}

int set_filename1(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: set_filename requires one argument",NULL);
	return TCL_ERROR;
	}
set_filename(argv[1]);
return TCL_OK;
}

int stop_logging(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
Tcl_ResetResult(interp);
set_filename(NULL);
return TCL_OK;
}

int log_statistics(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: log_statistics requires one argument",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: log_statistics: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=num_fields()){
	Tcl_AppendResult(interp,"ERROR: log_statistics: index too big",NULL);
	return TCL_ERROR;
	}
output_statistics(i);
return TCL_OK;
}

int num_values(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i;
Tcl_ResetResult(interp);
if(argc!=2){
	Tcl_AppendResult(interp,"ERROR: num_values requires one argument",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: num_values: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=num_stat()){
	Tcl_AppendResult(interp,"ERROR: num_values: index too big",NULL);
	return TCL_ERROR;
	}
Tcl_SetObjResult(interp,Tcl_NewIntObj(get_number_of_values(i)));
return TCL_OK;
}

int get_value1(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i,j;
Tcl_ResetResult(interp);
if(argc!=3){
	Tcl_AppendResult(interp,"ERROR: get_value requires two arguments",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: get_value: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=num_stat()){
	Tcl_AppendResult(interp,"ERROR: get_value: index too big",NULL);
	return TCL_ERROR;
	}
j=atol(argv[2]);
if(j<0){
	Tcl_AppendResult(interp,"ERROR: get_value: argument must be positive",NULL);
	return TCL_ERROR;
	}
Tcl_AppendResult(interp,get_value(i,j),NULL);	
return TCL_OK;
}

int get_value_name1(ClientData client_data,Tcl_Interp* interp,int argc,char *argv[])
{
long i,j;
Tcl_ResetResult(interp);
if(argc!=3){
	Tcl_AppendResult(interp,"ERROR: get_value_name requires two arguments",NULL);
	return TCL_ERROR;
	}
i=atol(argv[1]);
if(i<0){
	Tcl_AppendResult(interp,"ERROR: get_value_name: argument must be positive",NULL);
	return TCL_ERROR;
	}
if(i>=num_stat()){
	Tcl_AppendResult(interp,"ERROR: get_value_name: index too big",NULL);
	return TCL_ERROR;
	}
j=atol(argv[2]);
if(j<0){
	Tcl_AppendResult(interp,"ERROR: get_value_name: argument must be positive",NULL);
	return TCL_ERROR;
	}
Tcl_AppendResult(interp,get_value_name(i,j),NULL);	
return TCL_OK;
}

